/******************************************************************************
 CAdaExecTask.h

			Source File For CAdaExecTask Class
	

	Copyright (C) 1985-1992  New York University
	Copyright (C) 1994 George Washington University
	 
	This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
	system.  See the Ada/Ed README file for warranty (none) and distribution
	info and also the GNU General Public License for more details.


	by Manuel A. Perez

 ******************************************************************************/

#include "CAdaExecTask.h"
#include "CAdaApp.h"
#include "CLibrary.h"
#include "AdaGlobals.h"
#include "CFileMgr.h"

#include <TBUtilities.h>
#include <Exceptions.h>
#include <stdio.h>
#include <stdlib.h>
#include "ErrMessages.h"

extern	CApplication *gApplication;	/* The application */
extern	OSType	gSignature;			/* Creator for Application's files	*/


/****
 *	IAdaExecTask
 *
 ****/
void	CAdaExecTask::IAdaExecTask(Str255 bunit)
{
	Str255	n;

	CopyPString(bunit, bindingUnit);
	GetIndString(n, 20020, 4);
	IBkgndTask(n);
	SetPartID(kExec);
}

/****
 *	WriteOptions
 *
 ****/

void	CAdaExecTask::WriteOptions(void)
{
Str255 file, fileQuantum;
FILE *fp, *fQuantum;
CLibrary *lib;
ExOptions options;
Boolean trace;
Str255 str;

	// Write adaexec compile options to disk
	gFileMgr->GetOptionsFile(file);
	PtoCstr(file);

	_fcreator = gSignature;
	if (fp = fopen((char *)file, "w")) {
	
		// Process name (adaexec)
		fprintf(fp, "%#s\n", procName);

		// Get User Library
		lib = gAdaApp->GetUserLibrary();
		lib->WriteOptions(fp);


		// Get execute options
		gAdaApp->GetExOptions(&options);
		trace = (options.exOptSource || options.exOptRoutines ||
				 options.exOptException || options.exOptRendezvous ||
				 options.exOptTask);
		if (trace) {
			fprintf(fp, "-t\n");
			if (options.exOptSource)
				fprintf(fp, "a");
			if (options.exOptRoutines)
				fprintf(fp, "c");
			if (options.exOptException)
				fprintf(fp, "e");
			if (options.exOptRendezvous)
				fprintf(fp, "r");
			if (options.exOptTask)
				fprintf(fp, "t");
			fprintf(fp, "\n");
		}

		if (options.exRoundRobin) {
			// write to the other one
			fprintf(fp, "-r\n");
			fprintf(fp, "%d\n", options.exQuantumSize);
		}

#ifdef OLD
		// Write the round robin option
		gFileMgr->GetQSizeFile(fileQuantum);
		PtoCstr(fileQuantum);

		if (fQuantum = fopen((char *)fileQuantum, "r")) {
			int value;

			// read one file
			if ((fscanf(fQuantum, "%d", &value) != 1) || (value <= 0))
				value = 5;
			fclose(fQuantum);

			// write to the other one
			fprintf(fp, "-r\n");
			fprintf(fp, "%d\n", value);
		}
#endif


		// binding unit to exec
		if (bindingUnit[0] > 0) {
			fprintf(fp, "-m\n");
			fprintf(fp, "%#s\n", bindingUnit);
		}
		fclose(fp);
	}
	else {
		// Fail opening adagen options
		Failure(errWritingOptions, 0);
	}
}

/****
 *	AnnounceWithSound()
 *
 *	Don't play a sound from the monitor.
 *
 ****/

void	CAdaExecTask::AnnounceWithSound(void)
{
}

